<?php
session_start();
include "db.php";

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$user = $conn->query("SELECT * FROM users WHERE id=$user_id")->fetch_assoc();

// Dummy stats for cards
$dummy_stats = [
    ["title" => "Research Papers", "value" => "12", "icon" => "bi bi-file-earmark-text-fill", "color" => "primary"],
    ["title" => "Citations", "value" => "3.2K", "icon" => "bi bi-journal-text", "color" => "success"],
    ["title" => "Followers", "value" => "1.5K", "icon" => "bi bi-people-fill", "color" => "warning"],
    ["title" => "Projects", "value" => "8", "icon" => "bi bi-lightbulb-fill", "color" => "danger"],
];

// Dummy recent activities
$dummy_activities = [
    ["text" => "Published new research on Cancer Immunotherapy", "time" => "2 hrs ago"],
    ["text" => "Updated profile picture", "time" => "1 day ago"],
    ["text" => "Joined project: Clinical Trials 2025", "time" => "3 days ago"],
    ["text" => "Received 200 new citations this month", "time" => "5 days ago"],
];

// Dummy quick actions
$quick_actions = [
    ["title" => "Upload Paper", "icon" => "bi bi-cloud-upload-fill", "color" => "primary"],
    ["title" => "Start Project", "icon" => "bi bi-rocket-fill", "color" => "success"],
    ["title" => "Manage Team", "icon" => "bi bi-people-fill", "color" => "warning"],
    ["title" => "View Analytics", "icon" => "bi bi-bar-chart-fill", "color" => "danger"],
];
?>
<html>
<head>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        body { background-color: #f8f9fa; }
        .card-hover:hover { transform: translateY(-5px); transition: 0.3s; box-shadow: 0 10px 20px rgba(0,0,0,0.1); }
        .quick-action-btn { width: 100%; margin-bottom: 15px; }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-primary shadow">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold">Pharma Research</a>
    <div class="d-flex">
      <span class="text-white me-4">Membership ID: <?php echo $user['membership_id']; ?></span>
      <div class="dropdown">
        <a class="btn btn-light dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
          <?php echo $user['first_name']; ?>
        </a>
        <ul class="dropdown-menu dropdown-menu-end">
          <li><a class="dropdown-item" href="profile.php">Profile</a></li>
          <li><a class="dropdown-item" href="privacy.php">Privacy & Security</a></li>
          <li><a class="dropdown-item" href="share.php?mid=<?php echo $user['membership_id']; ?>">Share Profile</a></li>
          <li><hr class="dropdown-divider"></li>
          <li><a class="dropdown-item text-danger" href="logout.php">Logout</a></li>
        </ul>
      </div>
    </div>
  </div>
</nav>

<div class="container mt-4">

  <!-- Welcome Message -->
  <div class="alert alert-info shadow-sm">
    Welcome, <b><?php echo $user['first_name']; ?></b>! Manage your profile and dashboard below.
  </div>

  <!-- Stats Cards -->
  <div class="row g-3 mb-4">
    <?php foreach ($dummy_stats as $stat): ?>
      <div class="col-md-3">
        <div class="card card-hover shadow-sm border-0 text-center p-3">
          <i class="<?php echo $stat['icon']; ?> text-<?php echo $stat['color']; ?> fs-1"></i>
          <h4 class="mt-2"><?php echo $stat['value']; ?></h4>
          <p class="text-muted"><?php echo $stat['title']; ?></p>
        </div>
      </div>
    <?php endforeach; ?>
  </div>

  <div class="row g-3">

    <!-- Profile Card -->
    <div class="col-md-4">
      <div class="card shadow-sm border-0 p-3 text-center card-hover">
        <img src="https://via.placeholder.com/120" class="rounded-circle mb-3 shadow-sm" alt="Profile">
        <h5><?php echo $user['first_name']." ".$user['last_name']; ?></h5>
        <p class="text-muted">Pharma Research Scientist</p>
        <span class="badge bg-success mb-2">Active Member</span>
        <div class="d-grid">
            <?php foreach($quick_actions as $action): ?>
              <button class="btn btn-<?php echo $action['color']; ?> quick-action-btn">
                <i class="<?php echo $action['icon']; ?> me-2"></i><?php echo $action['title']; ?>
              </button>
            <?php endforeach; ?>
        </div>
      </div>
    </div>

    <!-- Recent Activities -->
    <div class="col-md-8">
      <div class="card shadow-sm border-0 card-hover">
        <div class="card-header bg-white fw-bold">Recent Activities</div>
        <div class="card-body">
          <ul class="list-group list-group-flush">
            <?php foreach ($dummy_activities as $act): ?>
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <div><i class="bi bi-check-circle-fill text-success me-2"></i><?php echo $act['text']; ?></div>
                <small class="text-muted"><?php echo $act['time']; ?></small>
              </li>
            <?php endforeach; ?>
          </ul>
        </div>
      </div>
    </div>

  </div>

</div>
</body>
</html>
